﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Security.Cryptography.X509Certificates;
using Kz.GammaTech.Cms;
using System.IO;

namespace Encrypt
{
    class Program
    {
        static void Main(string[] args)
        {
            
            // выбираем свой сертификат
            X509Store store2 = new X509Store("MY");
            X509Certificate2 cert1_sender = null;
            try
            {
                store2.Open(OpenFlags.ReadOnly);
                X509Certificate2Collection certCollection = store2.Certificates;
                X509Certificate2Collection signingCert1 = certCollection.Find(X509FindType.FindBySubjectName, "Sender", false);
                cert1_sender = signingCert1[0];
            }
            finally
            {
                store2.Close();
            }


            GammaEnvelopedCMS g_cms = new GammaEnvelopedCMS(true);
            g_cms.sender_profile = "profile://sender";
            g_cms.sender_cert = cert1_sender;
            // добавляем сертификат получателя
            FileStream f_cert = new FileStream("c:\\1\\ex_cert.cer", FileMode.Open);
            byte[] cert_b = new byte[f_cert.Length];
            f_cert.Read(cert_b, 0, cert_b.Length);
            f_cert.Close();
            g_cms.responder_cert = new X509Certificate2(cert_b);

            // шифруем
            byte[] enc_text = g_cms.Encrypt(System.Text.Encoding.ASCII.GetBytes("qwerty"));
			
			
            // получатель указывает свой профайл для расшифроваки
            GammaEnvelopedCMS g_cms_d = new GammaEnvelopedCMS(false);
            g_cms_d.responder_profile = "profile://responder";
            // и расшифровывает
            byte[] res = g_cms_d.Decrypt(enc_text);
            string hh = System.Text.Encoding.ASCII.GetString(res);			
        }
    }
}
